﻿using Microsoft.WindowsAzure.Storage.Table;
using System.Collections.Generic;
using System.Threading.Tasks;
using VA.PPMS.IWS.TableService.Interface.Entities;

namespace VA.PPMS.IWS.TableService.Interface
{
    public enum CloudTableType
    {
        DefaultTableNameSetting,
        ActivityTableNameSetting
    }

    public interface ITableService
    {
        int BatchSize { get; }

        int SuperBatchSize { get; }

        string StatusActive { get; }

        string StatusInactive { get; }
   
        Task<CloudTable> GetTableRef();

        Task<CloudTable> GetTableRef(CloudTableType tableType);

        Task CreateTable(CloudTableType tableType);

        Task SaveNpiStatusAsync(string npi, string npiType, string status);

        Task SaveNpiStatusBatchAsync(IList<NpiStatusEntity> list);

        Task SaveNpiStatusAsync(NpiStatusEntity npiStatus);

        Task<NpiStatusEntity> ReadNpiStatusAsync(string npi, string status);

        Task ClearNpiStatusAsync();

        Task SetActivity(ActivityHistoryEntity activity);

        Task<ActivityHistoryEntity> GetActivity(ActivityHistoryEntity.ActivityType activityType);

        Task SetProviderPayloadProcessing();

        Task ClearProviderPayloadProcessing();
    }
}